<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version details
 *
 * @package    theme adaptable
 * @copyright  2017 Jordi Rodilla
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 *
 *
 */

// General.
$string['choosereadme'] = '
<div class="clearfix">
<div class="well">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
<h2>Crèdits</h2>
<h3>Sobre...</h3>
<p>Adaptable és una plantilla per a Moodle, de dues columnes i tipus responsive, altament personalitzable i agafant de referència la popular plantilla BCU.</p>
<p>Aquesta plantilla està sota llicència GPL (GNU General Public License). Pots trobar la llicència complerta a: <a href="http://www.gnu.org/licenses/">http://www.gnu.org/licenses</a></p>
<p>Modifica-la / Millora-la / Comparteix-la</p>
<br>
<p>Aquest tema ha estat creat per:<br>
Jeremy Hopkins (Coventry University)<br>
Fernando Acedo (<a href="https://3-bits.com" target="_blank">3-bits.com</a>)</p>
<br>
<p>i d&#39;altres desenvolupadors, provadors, traductors i voluntaris (Veure <a href="adaptable/README.txt" target="_blank">README.txt</a>)</p>
<br>
<h3>Informar de les errades</h3>
<p>Pots informar de les errades trobades en aquest tema (i, si us plau, només de les errades) mitjançant el nostre <a href="https://bitbucket.org/covuni/moodle-theme_adaptable/issues" target="_blank">repositori a Bitbucket</a></p>
<br>
<h3>Suport Tècnic</h3>
<p>Pots sol·licitar suport mitjançant la web de Adaptable (només en anglès) <a href="https://adaptable.ws/support/support-tickets" target="_blank">Get Technical Support</a></p>
<br>
<p>o pots preguntar en el forum de moodle:</p>
<ul>
<li>Anglès: <a href="https://moodle.org/mod/forum/discuss.php?d=340404" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340404</a>
<li>Espanyol: <a href="https://moodle.org/mod/forum/discuss.php?d=326804" target="_blank">https://moodle.org/mod/forum/discuss.php?d=326804</a>
<li>Català: <a href="https://moodle.org/mod/forum/discuss.php?d=340406" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340406</a>
</ul>
<br>
<h3>Documentació</h3>
<p>Pròximament</p>
<br>
<h3>Demo</h3>
<p>Pots veure una demostració del lloc i descarregar l&#39;arxiu d&#39;instal·lació a <a href="https://adaptable.ws/demo">https://adaptable.ws/demo</a></p>
<br>
<p>Traducció Català (ca-ES): Jordi Rodilla</p>


</div>
</div>';

$string['pluginname'] = 'Adaptable';
$string['configtitle'] = 'Adaptable';

$string['region-middle'] = 'Centre';
$string['region-frnt-footer'] = 'Peu';
$string['region-side-post'] = 'Dreta';
$string['region-side-pre'] = 'Esquerra';
$string['frnt-footer'] = 'Els blocs situats a aquesta zona, només són visibles pels administradors.';

$string['region-frnt-market-a'] = 'Marketing-a';
$string['region-frnt-market-b'] = 'Marketing-b';
$string['region-frnt-market-c'] = 'Marketing-c';
$string['region-frnt-market-d'] = 'Marketing-d';
$string['region-frnt-market-e'] = 'Marketing-e';
$string['region-frnt-market-f'] = 'Marketing-f';
$string['region-frnt-market-g'] = 'Marketing-g';
$string['region-frnt-market-h'] = 'Marketing-h';
$string['region-frnt-market-i'] = 'Marketing-i';
$string['region-frnt-market-j'] = 'Marketing-j';
$string['region-frnt-market-k'] = 'Marketing-k';
$string['region-frnt-market-l'] = 'Marketing-l';
$string['region-frnt-market-m'] = 'Marketing-m';
$string['region-frnt-market-n'] = 'Marketing-n';
$string['region-frnt-market-o'] = 'Marketing-o';
$string['region-frnt-market-p'] = 'Marketing-p';
$string['region-frnt-market-q'] = 'Marketing-q';
$string['region-frnt-market-r'] = 'Marketing-r';
$string['region-frnt-market-s'] = 'Marketing-s';
$string['region-frnt-market-t'] = 'Marketing-t';


// Settings page headings ******************************************.
$string['settingsmaincolors'] = 'Colors principals';
$string['settingsheadercolors'] = 'Colors capçalera';
$string['settingsmenucolors'] = 'Colors menú';
$string['settingsmobilemenucolors'] = 'Colors menú mòbil';
$string['settingsinfoboxcolors'] = 'Colors quadre informatiu principal';
$string['settingssecondinfoboxcolors'] = 'Colors quadre informatiu secundari';
$string['settingsmarketingcolors'] = 'Colors blocs moodle';
$string['settingsoverlaycolors'] = 'Colors blocs cursos';
$string['settingsnavbarcolors'] = 'Colors de la barra de navegació';
$string['settingsalertbox'] = 'Alertes';
$string['settingsbreadcrumbcolors'] = 'Colors de la ruta de navegació';
$string['settingsmessagescolors'] = 'Colors dels missatges emergents';
$string['settingsfootercolors'] = 'Colors del peu de pàgina';
$string['settingsfonts'] = 'Fonts';
$string['analyticssettings'] = 'Analítica Web';


// Admin Menu Strings.
$string['blocksettings'] = 'Blocs';
$string['frontpagealertsettings'] = 'Alertes';
$string['frontpageblockregionsettings'] = 'Creador de regions per a blocs';
$string['frontpagealertboxssettings'] = 'Configuració d&#39;alertes';
$string['dashboardblockregionsettings'] = 'Constructor de regions de l&#39;Área Personal';
$string['frontpageblocksettings'] = 'Blocs promocionals';
$string['frontpagetickersettings'] = 'Anuncis';
$string['frontpageslidersettings'] = 'Presentació diapositives';
$string['frontpagecoursesettings'] = 'Cursos';
$string['frontpagesettingsheading'] = 'Pàgina d&#39;Inici';
$string['frontpagedesc'] = 'Configurar la forma en que es mostren els cursos a la pàgina inicial.';
$string['frontpagerenderer'] = 'Blocs de cursos';
$string['frontpagerendererdesc'] = 'Configurar la forma en que que es mostren els cursos a la pàgina inicial.';
$string['frontpagerendereroption1'] = 'Blocs';
$string['frontpagerendereroption2'] = 'Blocs sense incrustar';
$string['frontpagerendereroption3'] = 'Per defecte';
$string['frontpagerendereroption4'] = 'Tipus Coventry';


// Ticker **********************************************************.
$string['tickersettings'] = 'Anuncis';
$string['tickersettingsheading'] = 'Configura els anuncis de la pàgina d&#39;inici. Veure posició <a href="./adaptable/pix/layout.png" target="_blank"> aqui</a>';
$string['tickerdesc'] = 'Aqui pots configurar els anuncis de la pàgina d&#39;inici del teu moodle.
    Només has d&#39;introduir una llista tipus HTML i incloure enllaços.
    Nota:No has d&#39;afegir etiquetes ul a la llista, només li. Els editors de Moodel tenen tendència a afegir etiquetes ul a les llistes.
    Si no funciona correctament, canvia a mode HTML i comprova que només hi ha etiquetes li:
    <pre>
    &lt;li&gt;Anunci 1.....&lt;/li&gt;
    &lt;li&gt;Anunci 2.....&lt;/li&gt;
    </pre>
    <br>
    Pots controlar diferents seccions d&#39;anuncis depenent d&#39;un camp de perfil d&#39;usuari personalitzat i així mostrar diferents anuncis a diferents perfils.';
$string['tickerdefault'] = 'No hi ha anuncis per mostrar';

$string['enableticker'] = 'Activar els anuncis a la pàgina d&#39;inici';
$string['enabletickerdesc'] = 'Marcar per activar els anuncis a la pàgina d&#39;inici.';

$string['enabletickermy'] = 'Activar els anuncis a El meu Inici / Àrea Personal';
$string['enabletickermydesc'] = 'Marcar per activar els anuncis a la pàgina  El meu Inici / Àrea Personal.';

$string['enabletickerc'] = 'Activar els anuncis a les pàgines internes';
$string['enabletickercdesc'] = 'Marcar per activar els anuncis a les pàgines internes.';

$string['tickerwidth'] = 'Amplada Anuncis';
$string['tickerwidthdesc'] = 'Pots utilitzar aquesta opció per fixar l&#39;amplada al 100% dels anuncis.';

$string['tickertext1'] = 'Text Anuncis 1';
$string['tickertext1desc'] = 'Afegir els anuncis en format de llista HTML. Veure <a href="adaptable/README.txt">README.md</a> per a més informació.';

$string['tickertext2'] = 'Text Anuncis 2';
$string['tickertext2desc'] = 'Afegir els anuncis en format de llista HTML per a un segon tipus d&#39;usuari. Veure <a href="adaptable/README.md">README.md</a> per a més informació.';

$string['tickertextprofilefield'] = 'Nom del camp personalitzat del perfil Field Name=Value (opcional)';
$string['tickertextprofilefielddesc'] = 'Afegeix una regla d&#39;accés utilitzant un camp de perfil personalitzat. Exemple: usertype=alumne';

$string['ticker'] = 'Anuncis';

// Slideshow *******************************************************.
$string['slideshowsettings'] = 'Presentació de diapositives';
$string['slideshowsettingsheading'] = 'Personalitza la presentació de diapositives de la pàgina d&#39;inici';
$string['slideshowdesc'] = 'Puja imatges, afegeix enllaços i descripcions a les dispositives de la presentació de la pàgina d&#39;inici.';

$string['sliderimage'] = 'Imatge de la diapositiva';
$string['sliderimagedesc'] = 'Afegeix una imatge a la diapositiva.';

$string['slidercaption'] = 'Text de la diapositiva';
$string['slidercaptiondesc'] = 'Afegeix un text a la diapositiva.';

$string['sliderurl'] = 'URL de la diapositiva';
$string['sliderurldesc'] = 'Afegeix una URL a enllaçar des de la diapositiva.';

$string['slidermargintop'] = 'Marge superior de la presentació de diapositives';
$string['slidermargintopdesc'] = 'Estableix el marge superior de la presentació de diapositives.';

$string['slidermarginbottom'] = 'Marge inferior de la presentació de diapositives';
$string['slidermarginbottomdesc'] = 'Estableix el marge inferior de la presentació de diapositives.';

$string['sliderenabled'] = 'Activar la presentació de diapositives';
$string['sliderenableddesc'] = 'Activa la presentació de diapositives a la pàgina principal.';

$string['sliderfullscreen'] = 'Presentació de diapositives a amplada complerta';
$string['sliderfullscreendesc'] = 'Mostra la presentació de diapositives en tot l&#39;ample de la pantalla.';

$string['slideroption2'] = 'Seleccionar tipus de presentació de diapositives';
$string['slideroption2desc'] = 'Selecciona el tipus de presentació de diapositives <strong>i picar Desar</strong>per mostrar els colors de l&#39;estil seleccionat.';

$string['slideroption2snippet'] = '<p>Exemple HTML per al text de les diapositives:</p>
<pre>
&#x3C;div class=&#x22;span6 col-sm-6&#x22;&#x3E;
&#x3C;h3&#x3E;Fer a mà&#x3C;/h3&#x3E; &#x3C;h4&#x3E;pixels i codi per a la comunitat Moodle&#x3C;/h4&#x3E;
&#x3C;a href=&#x22;#&#x22; class=&#x22;submit&#x22;&#x3E;Si us plau, fes d&#39;Adaptable un dels teus temes favorits&#x3C;/a&#x3E;
</pre>';

$string['slidercount'] = 'Nombre de diapositives';
$string['slidercountdesc'] = 'Estableix el nombre de diapositives a mostrar a la pàgina principal i <strong>fes clic a Desar</strong> per introduir la informació de la resta de camps.';

$string['sliderh3color'] = 'Color del text H3 de l&#39;estil de presentació 1';
$string['sliderh3colordesc'] = 'Estableix el color del text de l&#39;etiqueta H3 quan s&#39;utilitza l&#39;estil de presentació 1.';

$string['sliderh4color'] = 'Color del text H4 de l&#39;estil de presentació 1';
$string['sliderh4colordesc'] = 'Estableix el color del text de l&#39;etiqueta H4 quan s&#39;utilitza l&#39;estil de presentació 1.';

$string['slidersubmitcolor'] = 'Color del text del botó de l&#39;estil de presentació 1';
$string['slidersubmitcolordesc'] = 'Estableix el color del text del botó quan s&#39;utilitza l&#39;estil de presentació 1.';

$string['slidersubmitbgcolor'] = 'Color del botó de l&#39;estil de presentació 1';
$string['slidersubmitbgcolordesc'] = 'Estableix el color del botó quan s&#39;utilitza l&#39;estil de presentació 1.';

$string['slider2h3color'] = 'Color del text H3 de l&#39;estil de presentació 2';
$string['slider2h3colordesc'] = 'Estableix el color del text de l&#39;etiqueta H3 quan s&#39;utilitza l&#39;estil de presentació 2.';

$string['slider2h4color'] = 'Color del text H4 de l&#39;estil de presentació 2';
$string['slider2h4colordesc'] = 'Estableix el color del text de l&#39;etiqueta H4 quan s&#39;utilitza l&#39;estil de presentació 2.';

$string['slider2h3bgcolor'] = 'Color de fons H3 de l&#39;estil de presentació 2';
$string['slider2h3bgcolordesc'] = 'Estableix el color de fons de l&#39;etiqueta H3 quan s&#39;utilitza l&#39;estil de presentació 2.';

$string['slider2h4bgcolor'] = 'Color de fons H4 de l&#39;estil de presentació 2';
$string['slider2h4bgcolordesc'] = 'Estableix el color de fons de l&#39;etiqueta H4 quan s&#39;utilitza l&#39;estil de presentació 2.';

$string['slideroption2submitcolor'] = 'Color de fons de l&#39;enllaç de l&#39;estil de presentació 2';
$string['slideroption2submitcolordesc'] = 'Estableix el color de fons del text de l&#39;enllaç quan s&#39;utilitza l&#39;estil de presentació 2.';

$string['slideroption2color'] = 'Color de fons de la presentació de diapositives tipus 2';
$string['slideroption2colordesc'] = 'Estableix el color de fons de la diapositiva quan s&#39;utilitza l&#39;estil de presentació 2.';

$string['slideroption2a'] = 'Color de fons de les fletxes de la presentació de diapositives tipus 2';
$string['slideroption2adesc'] = 'Estableix el color de les fletxes de la presentació de diapositives quan s&#39;utilitza l&#39;estil de presentació 2.';

$string['sliderstyle1'] = 'Diapositives estil 1';
$string['sliderstyle2'] = 'Diapositives estil 2';


// Regiones para Bloques ***************************************************.
$string['blocklayoutbuilder'] = 'Creador de regions per a blocs';
$string['blocklayoutbuilderdesc'] = 'A continuació pots crear la teva pròpia distribució de regions per als blocs de moodle a la pàgina principal.
Per afegir contingut a aquestes regions necessitaràs <strong>Activar edició a la pàgina principal de Moodle</strong>.
Llavors podràs arrossegar i deixar anar els blocs a les regions creades.';

$string['dash_blocklayoutbuilder'] = 'Regions de l&#39;Àrea Personal';
$string['dash_blocklayoutbuilderdesc'] = 'A continuació pots crear la teva pròpia estructura de regions per a blocs a l&#39;Àrea Personal.
Per a afegir aquestes regions necessitaràs <strong>Activar Edició a la pàgina de l&#39;Àrea Personal</strong>.<br>
Llavors podràs arrossegar i deixar anar blocs a les regions que has creat.';

$string['blocklayoutlayoutcheck'] = 'Comprova la distribució';
$string['blocklayoutlayoutcheckdesc'] = 'Utilitza aquesta opció per veure la distribució creada i comprovar el nombre de blocs que has utilitzat.';
$string['blocklayoutlayoutcount1'] = 'Pots crear un màxim de ';
$string['blocklayoutlayoutcount2'] = ' regions per a blocs. Ara estàs utilitzant: ';

$string['blocklayoutlayoutrow'] = 'Files de regions per a blocs';
$string['blocklayoutlayoutrowdesc'] = 'Afegeix / estableix la distribució de files de les regions per a blocs de la pàgina principal.';

$string['dashblocklayoutlayoutrow'] = 'Fila de regions del Panell de Control ';
$string['dashblocklayoutlayoutrowdesc'] = 'Afegeix / estableix l&#39;estructura de les regions per a blocs a la pàgina de l&#39;Àrea Personal.';

$string['frontpageblocksenabled'] = 'Activa les regions per a blocs a la pàgina principal';
$string['frontpageblocksenableddesc'] = 'Activa o desactiva les regions per a blocs de la pàgina principal.
Pots arrossegar i deixar anar els blocs a les regions creades';

$string['dashblocksenabled'] = 'Activar les regions personalitzades a la pàgina de l&#39;Àrea Personal';
$string['dashblocksenableddesc'] = 'Pots activar / desactivar les regions personalitzades de la pàgina de l&#39;Àrea Personal.
Pots arrossegar i deixar anar els blocs a les regions que has creat';

$string['layoutcheck'] = 'Comprova la distribució';
$string['layoutcheckdesc'] = 'Utilitza aquesta opció per a veure la distribució creada i comprovar el nombre de blocs que has utilitzat.';
$string['layoutcount1'] = 'Pots crear un màxim de ';
$string['layoutcount2'] = ' regions per a blocs. Ara estàs utilitzant: ';


// Bloques promocionales & Cuadros Informativos *************************************.
$string['marketingsettings'] = 'Blocs promocionals';
$string['marketingsettingsheading'] = 'Personalitza els blocs promocionals que apareixen a la pàgina d&#39;inici. Veure la distribució <a href="./../theme/adaptable/pix/layout.png" target="_blank">aqui</a>';
$string['marketingdesc'] = 'Disposes de dos quadres informatius als que pots aplicar diferents estils. A més pots activar el creador de regions
per a blocs i decidir quants blocs vols mostrar i la seva distribució a la pàgina d&#39;inici. Pots veure la distribució de les diferents regions a l&#39;arxiu  <a href="/adaptable/README.md" target="_blank">README.md</a>';

$string['marketingbuilderheading'] = 'Creador de regions per a blocs promocionals';
$string['marketingbuilderdesc'] = 'Utilitza aquesta opció per veure la distribució creada i comprovar el nombre de blocs promocionals que has utilitzat.';

$string['marketlayoutrow'] = 'Files de regions per a blocs promocionals';
$string['marketlayoutrowdesc'] = 'Afegeix / estableix la distribució de files de les regions per a blocs promocionals de la pàgina principal.';

$string['market'] = 'Bloc promocional ';
$string['marketdesc'] = 'Afegeix el codi HTML del bloc promocional (veure l&#39;arxiu <a href="./../theme/adaptable/README.md" target="_blank">README</a> per a més exemples).';

$string['layoutaddcontent'] = 'Afegeix contingut als blocs promocionals:';
$string['layoutaddcontentdesc1'] = 'Has configurat ';
$string['layoutaddcontentdesc2'] = ' blocs promocionals. Si estàs d&#39;acord amb la distribució afegeix el contingut dels blocs promocionals.
Si no estàs d&#39;acord, utilitza el creador de regions per a blocs promocionals per realitzar canvis<br />';

$string['infobox'] = 'Quadre informatiu 1';
$string['infoboxdesc'] = 'Afegeix el codi HTML del quadre informatiu 1 (veure l&#39;arxiu <a href="./../theme/adaptable/README.md" target="_blank">README</a> per a més exemples)';

$string['infoboxfullscreen'] = 'Quadres informatius a amplada complerta';
$string['infoboxfullscreendesc'] = 'Marca aquesta opció per mostrar els quadres informatius a l&#39;amplada complerta de la pantalla.';

$string['infobox2'] = 'Quadre informatiu 2';
$string['infobox2desc'] = 'Afegeix el codi HTML del quadre informatiu 2 (veure l&#39;arxiu <a href="./../theme/adaptable/README.md" target="_blank">README</a> per a més exemples)';

$string['frontpagemarketenabled'] = 'Activar els blocs promocionals';
$string['frontpagemarketenableddesc'] = 'Activar els blocs promocionals a la pàgina d&#39;inici.';

$string['frontpagemarketoption'] = 'Estil dels blocs promocionals';
$string['frontpagemarketoptiondesc'] = 'Estableix l&#39;estil dels blocs promocionals. Configura el color d&#39;aquesta opció a la pàgina de colors.
Nota: L&#39;estil BCU està creat per mostrar la imatge a la part superior del bloc.';

$string['bcustyle'] = 'Estil BCU';
$string['coventrystyle'] = 'Estil Coventry';
$string['nostyle'] = 'Sense estil';


// Footer **********************************************************.
$string['footersettings'] = 'Peu de Pàgina';
$string['footersettingsheading'] = 'A continuació pots crear la teva pròpia distribució de regions per al peu de pàgina. Per afegir contingut a aquestes regions necessitaràs <strong>Activar edició a la pàgina principal de Moodle</strong>. Llavors podràs arrossegar i deixar anar els blocs a les regions creades.';

$string['footerdesc'] = 'Controla el contingut que es mostra a les seccions del peu de pàgina.';

$string['showfooterblocks'] = 'Mostrar blocs al peu de pàgina';
$string['showfooterblocksdesc'] = 'Mostrar els blocs personalitzats al peu de pàgina.';

$string['footerblocksplacement'] = 'Pàgines on mostrar els blocs del peu de pàgina';
$string['footerblocksplacementdesc'] = 'Definir els llocs on s&#39;han de mostrar els blocs del peu de pàgina. Tot el llocs és la opció per defecte.';
$string['footerblocksplacement1'] = 'Tot el lloc';
$string['footerblocksplacement2'] = 'Pàgina Inicial';
$string['footerblocksplacement3'] = 'Mai';

$string['footerlayoutrow'] = 'Creador de regions per als blocs del peu de pàgina';
$string['footerlayoutrowdesc'] = 'Utilitza aquesta opció per veure la distribució creada i comprovar el nombre de blocs del peu de pàgina que has utilitzat.';

$string['footnote'] = 'Text del bloc del peu de pàgina ';
$string['footnotedesc'] = 'Afegeix el codi HTML del bloc de peu de pàgina (veure l&#39;arxiu <a href="./../theme/adaptable/README.md" target="_blank">README</a> per a més exemples)';

$string['footerheader'] = 'Títol del bloc del peu de pàgina ';
$string['footerdesc'] = 'Afegeix el títol del bloc del peu de pàgina';

$string['footercontent'] = 'Contingut del bloc del peu de pàgina';
$string['footercontentdesc'] = 'Afegeix el codi HTML del bloc de peu de pàgina (veure l&#39;arxiu <a href="./../theme/adaptable/README.md" target="_blank">README</a> per a més exemples)';

$string['hidefootersocial'] = 'Mostrar icones socials';
$string['hidefootersocialdesc'] = 'Mostra les icones socials al peu de pàgina sota els blocs.';


// Moodle Docs link.
$string['moodledocs'] = 'Mostrar l&#39;enllaç a Moodle Docs';
$string['moodledocsdesc'] = 'Mostrar un enllaç a Moodle Docs al peu de pàgina.';


// NavBar **********************************************************.
$string['stickynavbar'] = 'Fixar la barra de navegació';
$string['stickynavbardesc'] = 'Fixar la barra de navegació a la part superior de la pàgina.';

$string['navbarcachetime'] = 'Caché de la barra de navegació';
$string['navbarcachetimedesc'] = 'El temps, en minuts, que es conserva la barra de navegació.';

$string['navbarmenusettings'] = 'Menú Navegació';
$string['navbarmenusettingsheading'] = 'Personalitzar el menú de la barra de navegació';
$string['navbarmenusettingsdesc'] = 'Afegir menús a la barra de navegació.';

$string['navbarsettings'] = 'Barra de navegació';
$string['navbarsettingsheading'] = 'Personalitzar la barra de navegació';
$string['navbardesc'] = 'Controlar els diferents elements a mostrar a la barra de navegació.';

if ($CFG->version > 2015051100) {
    $string['enablemy'] = 'Àrea Personal';
    $string['enablemydesc'] = 'Mostrar l&#39;enllaç a l&#39;Àrea Personal.';
} else {
    $string['enablemy'] = 'Inici';
    $string['enablemydesc'] = 'Mostrar l&#39;enllaç a l&#39;Inici';
};

$string['enableprofile'] = 'Perfil usuari';
$string['enableprofiledesc'] = 'Mostrar l&#39;enllaç del perfil d&#39;usuari.';

$string['enableeditprofile'] = 'Editar perfil';
$string['enableeditprofiledesc'] = 'Mostrar l&#39;enllaç per editar el perfil de l&#39;usuari.';

$string['enablebadges'] = 'Insignies';
$string['enablebadgesdesc'] = 'Mostrar l&#39;enllaç de les insignies de l&#39;usuari.';

$string['enablegrades'] = 'Qualificacions';
$string['enablegradesdesc'] = 'Mostrar l&#39;enllaç de les qualificacions de l&#39;usuari.';

$string['enablecalendar'] = 'Calendari';
$string['enablecalendardesc'] = 'Mostrar l&#39;enllaç al calendari de l&#39;usuari.';

$string['enableprivatefiles'] = 'Arxius privats';
$string['enableprivatefilesdesc'] = 'Mostrar l&#39;enllaç als arxius privats de l&#39;usuari.';

$string['enablesearchbox'] = 'Activar quadre de cerca';
$string['enablesearchboxdesc'] = 'Mostrar el quadre de cerca a la part superior de la pantalla.';

$string['enablepref'] = 'Preferències';
$string['enableprefdesc'] = 'Mostrar l&#39;enllaç a les preferències de l&#39;usuari.';

$string['enablenote'] = 'Notificacions';
$string['enablenotedesc'] = 'Mostrar l&#39;enllaç pàgina de notificacions.';

$string['enableblog'] = 'Blocs de l&#39;usuari';
$string['enableblogdesc'] = 'Mostrar l&#39;enllaç als blocs de l&#39;usuari.';

$string['enableposts'] = 'Les meves entrades';
$string['enablepostsdesc'] = 'Mostrar l&#39;enllaç a les entrades als fòrums realitzats per l&#39;usuari.';

$string['enablefeed'] = 'Les meves opinions';
$string['enablefeeddesc'] = 'Mostrar l&#39;enllaç a la pàgina "Opinions" - <i>Nota: aquesta opció requereix el <a href="https://moodle.org/plugins/report_myfeedback" target="blank">plugin My Feedback</a> instal·lat';

$string['myblogs'] = 'Els meus Blocs';

$string['noenrolments'] = 'No hi ha matriculacions.';

$string['enablemyhomedesc'] = 'Mostrar un enllaç a {$a}';
$string['enableeventsdesc'] = 'Mostrar un enllaç al calendari';
$string['enablemysitesdesc'] = 'Mostrar els cursos de l&#39;usuari';
$string['enablethiscoursedesc'] = 'Mostrar les activitats del curs actual';

$string['mysitessortoverride'] = 'Activar l&#39;ordre personalitzat de "Els Meus Cursos"';
$string['mysitessortoverridedesc'] = 'Utilitza camps personalitzats o textos (any, edat, ...) per colapsar els cursos en un desplegable.';
$string['mysitessortoverridefield'] = 'Camp personalitzat o text per filtrar "Els Meus Cursos"';
$string['mysitessortoverridefielddesc'] = 'Llista amb delimitació per comes dels camps o textos a comprovar al nom curt del curs.';

$string['mysitessortoverrideoff'] = 'Mostrar llista de cursos.';
$string['mysitessortoverridestrings'] = 'Mostra una llista amb tots els cursos als que està matriculat l&#39;alumne. La resta són mostrats a un submenú.';
$string['mysitessortoverrideprofilefields'] = 'Mostra una llista amb els cursos coincidents com a camp personalitzat. La resta són mostrats a un submenú.';
$string['mysitessortoverrideprofilefieldscohort'] = 'Mostra els cursos coincidents amb un camp de perfil i els cohorts en primer lloc. La resta són mostrats a un submenú.';

$string['mysitesmaxlength'] = 'Longitud màxima del títol del curs a "Els Meus Cursos"';
$string['mysitesmaxlengthdesc'] = 'Ajusta la longitud màxima del títol del curs a mostrar a "Els Meus Cursos". La longitud dependrà de la mida i de la font utilitzada.';

$string['mycoursesmenulimit'] = 'Límit menú Els meus Cursos';
$string['mycoursesmenulimitdesc'] = 'Estableix el nombre màxim de cursos que apareixen al menú Els Meus Cursos. 0 mostrarà tots els cursos.';

$string['usernavheading'] = 'Personalitzar el menú d&#39;usuari';
$string['usernavdesc'] = 'Permet personalitzar els elements que apareixen al menú d&#39;usuari.';
$string['enablehomedesc'] = 'Mostrar enllaç a Inici';

$string['enablehomeredirect'] = 'Activar redirect=0';
$string['enablehomeredirectdesc'] = 'Activa la opció redirect=0 per a redirigir a la pàgina inicial del lloc. Aquesta opció pot utilitzar-se a llocs que tenen l&#39;Àrea Personal com a pàgina per defecte. Desactivada preveu redigirir als usuaris a la pàgina inicial i són redirigits a l&#39;Àrea Personal';


// Colours *********************************************************.
$string['colorsettings'] = 'Colors';
$string['colorsettingsheading'] = 'Modifica els colors principals utilitzats a la plantilla.';
$string['colordesc'] = 'Pots seleccionar els colors que desitgis per ser utilitzats per la plantilla. Utilitza la notació HEX estàndard. També pots utilitzar com a valors <i>transparent</i> i <i>inherited.</i>';
$string['linkcolor'] = 'Color enllaç';
$string['linkcolordesc'] = 'Estableix el color dels enllaços.';

$string['linkhover'] = 'Color sobre enllaç';
$string['linkhoverdesc'] = 'Estableix el color quan passa el cursor sobre els enllaços.';

$string['backcolor'] = 'Color de fons';
$string['backcolordesc'] = 'Estableix el color de fons de la plantilla.';

$string['regionmaincolor'] = 'Color de la regió principal';
$string['regionmaincolordesc'] = 'Estableix el color de fons de la regió principal.';

$string['maincolor'] = 'Color principal';
$string['maincolordesc'] = 'Estableix el color principal del lloc.';

$string['footertextcolor'] = 'Color de text del peu de pàgina superior';
$string['footertextcolordesc'] = 'Estableix el color de text al peu de pàgina superior.';

$string['footerbkcolor'] = 'Color de fons del peu de pàgina superior';
$string['footerbkcolordesc'] = 'Estableix el color de fons del peu de pàgina superior.';

$string['footertextcolor2'] = 'Color del text del peu de pàgina inferior';
$string['footertextcolor2desc'] = 'Estableix el color del text del peu de pàgina inferior.';

$string['footerlinkcolor'] = 'Color dels enllaços del peu de pàgina';
$string['footerlinkcolordesc'] = 'Estableix el color dels enllaços del peu de pàgina.';

$string['headerbkcolor'] = 'Color de fons de la part superior de la capçalera';
$string['headerbkcolordesc'] = 'Estableix el color de fons de la part superior de la capçalera.';

$string['msgbadgecolor'] = 'Color de fons del marcador de missatges.';
$string['msgbadgecolordesc'] = 'Estableix el color de fons del marcador de missatges de la capçalera (on es mostra el número de missatges no llegits)';

$string['headerbkcolor2'] = 'Color de fons de la part inferior de la capçalera';
$string['headerbkcolor2desc'] = 'Estableix el color de fons de la part inferior de la capçalera.';

$string['headertextcolor'] = 'Color de text i enllaços de la part superior de la capçalera';
$string['headertextcolordesc'] = 'Estableix el color de text i enllaços de la part superior de la capçalera.';

$string['headertextcolor2'] = 'Color del text i enllaços de la part inferior de la capçalera';
$string['headertextcolor2desc'] = 'Estableix el color de text i enllaços de la part inferior de la capçalera.';

$string['blockheadercolor'] = 'Color del text de la capçalera dels blocs';
$string['blockheadercolordesc'] = 'Estableix el color del text de la capçalera dels blocs.';

$string['blockbackgroundcolor'] = 'Color de fons dels blocs';
$string['blockbackgroundcolordesc'] = 'Estableix el color de fons dels blocs.';

$string['blockheaderbackgroundcolor'] = 'Color de fons dels encapçalaments dels blocs';
$string['blockheaderbackgroundcolordesc'] = 'Estableix el color de fons dels encapçalaments dels blocs.';

$string['blockbordercolor'] = 'Color de la bora dels blocs';
$string['blockbordercolordesc'] = 'Estableix el color de la bora dels blocs.';

$string['blocklinkcolor'] = 'Color d&#39;enllaç dels blocs';
$string['blocklinkcolordesc'] = 'Estableix el color dels enllaços dels blocs.';

$string['blocklinkhovercolor'] = 'Color dels enllaços dels blocs';
$string['blocklinkhovercolordesc'] = 'Estableix el color hover dels enllaços dels blocs.';

$string['blockregionbackground'] = 'Color de fons de les regions per a blocs';
$string['blockregionbackgrounddesc'] = 'Estableix el color de fons del contenidor del constructor de blocs de la pàgina principal.';

$string['blockheaderbordertop'] = 'Gruix de la bora superior dels blocs';
$string['blockheaderbordertopdesc'] = 'Estableix el gruix de la bora superior dels blocs.';

$string['blockheaderborderleft'] = 'Gruix de la bora esquerra dels blocs';
$string['blockheaderborderleftdesc'] = 'Estableix el gruix de la bora esquerra dels blocs.';

$string['blockheaderborderright'] = 'Gruix de la bora dreta dels blocs';
$string['blockheaderborderrightdesc'] = 'Estableix el gruix de la bora dreta dels blocs.';

$string['blockheaderborderbottom'] = 'Gruix de la bora inferior dels blocs';
$string['blockheaderborderbottomdesc'] = 'Estableix el gruix de la bora inferior dels blocs.';

$string['blockmainbordertop'] = 'Gruix de la bora superior del bloc central';
$string['blockmainbordertopdesc'] = 'Estableix el gruix de la bora superior del bloc central.';

$string['blockmainborderleft'] = 'Gruix de la bora esquerra del bloc central';
$string['blockmainborderleftdesc'] = 'Estableix el gruix de la bora esquerra del bloc central.';

$string['blockmainborderright'] = 'Gruix de la bora dreta del bloc central';
$string['blockmainborderrightdesc'] = 'Estableix el gruix de la bora dreta del bloc central.';

$string['blockmainborderbottom'] = 'Gruix de la bora inferior del bloc central';
$string['blockmainborderbottomdesc'] = 'Estableix el gruix de la bora inferior del bloc central.';

$string['blockheaderbordertopstile'] = 'Estil de la bora dels blocs';
$string['blockheaderbordertopstiledesc'] = 'Estableix l&#39;estil de la bora dels blocs laterals.';

$string['blockmainbordertopstile'] = 'Estil de la bora del bloc central';
$string['blockmainbordertopstiledesc'] = 'Estableix l&#39;estil de la bora dels blocs centrals.';

$string['blockheadertopradius'] = 'Radi de les cantonades superiors dels blocs laterals';
$string['blockheadertopradiusdesc'] = 'Radi de les cantonades superiors dels blocs laterals. Valor més alt és igual a efecte arrodonit.';

$string['blockheaderbottomradius'] = 'Radi de les cantonades inferiors dels blocs laterals';
$string['blockheaderbottomradiusdesc'] = 'Radi de les cantonades inferiors dels blocs laterals. Valor més alt és igual a efecte arrodonit.';

$string['blockmaintopradius'] = 'Radi de les cantonades superiors dels blocs centrals';
$string['blockmaintopradiusdesc'] = 'Radi de les cantonades superiors dels blocs centrals. Valor més alto és igual a efecte arrodonit.';

$string['blockmainbottomradius'] = 'Radi de les cantonades inferiors dels blocs centrals';
$string['blockmainbottomradiusdesc'] = 'Radi de les cantonades inferiors dels blocs centrals. Valor més alto és igual a efecte arrodonit.';

$string['marketblockbordercolor'] = 'Color de la bora dels blocs promocionals';
$string['marketblockbordercolordesc'] = 'Estableix el color de la bora dels blocs promocionals.';

$string['marketblocksbackgroundcolor'] = 'Color de fons de la regió dels blocs promocionals.';
$string['marketblocksbackgroundcolordesc'] = 'Estableix el color de fons de la regió dels blocs promocionals.';

$string['sectionheadingcolor'] = 'Color del text de la capçalera de secció';
$string['sectionheadingcolordesc'] = 'Estableix el color del text de la capçalera del tema actual.';

$string['homebk'] = 'Imatge de fons';
$string['homebkdesc'] = 'Carrega la imatge de fons per a la plantilla.';

$string['editonbk'] = 'Color de fons dels botons d&#39;edició i personalització activats';
$string['editonbkdesc'] = 'Estableix el color de fons dels botons d&#39;edició i personalització quan estan activats.';

$string['editoffbk'] = 'Color de fons dels botons d&#39;edició i personalització desactivats';
$string['editoffbkdesc'] = 'Estableix el color de fons dels botons d&#39;edició i personalització quan estan desactivats.';

$string['dividingline'] = 'Color de la línia divisòria de la capçalera';
$string['dividinglinedesc'] = 'Estableix el color de la línia divisòria de la capçalera. Utilitza el mateix color que la capçalera per eliminar-la.';

$string['dividingline2'] = 'Color de la línia divisòria del peu de pàgina';
$string['dividingline2desc'] = 'Estableix el color de la línia divisòria del peu de pàgina. Utilitza el mateix color que el peu per eliminar-la.';

$string['navbarborder'] = 'Color de la bora inferior de la barra de navegació';
$string['navbarborderdesc'] = 'Estableix el color de la bora inferior de la barra de navegació.';

$string['navbarhover'] = 'Color Hover de la barra de navegació';
$string['navbarhoverdesc'] = 'Estableix el color de fons al passar el cursor sobre els ítems del menú de la barra de navegació.';

$string['breadcrumb'] = 'Color de fons de la guia d&#39;exploració';
$string['breadcrumbdesc'] = 'Estableix el color de fons de la guia d&#39;exploració.';

$string['breadcrumbtextcolor'] = 'Color de text de la guia d&#39;exploració';
$string['breadcrumbtextcolordesc'] = 'Estableix el color de text de la guia d&#39;exploració.';

$string['activebreadcrumb'] = 'Color de fons de la guia d&#39;exploració activa';
$string['activebreadcrumbdesc'] = 'Estableix el color de fons de la guia d&#39;exploració activa.';

$string['messagepopupbackground'] = 'Color de fons dels missatges emergents';
$string['messagepopupbackgrounddesc'] = 'Estableix el color de fons de la capçalera dels missatges emergents.';

$string['messagepopupcolor'] = 'Color de text dels missatges emergents';
$string['messagepopupcolordesc'] = ' Estableix el color de text de la capçalera dels missatges emergents.';

$string['menubkcolor'] = 'Color de fons del menú principal';
$string['menubkcolordesc'] = 'Estableix el color de fons del menú principal.';

$string['menubordercolor'] = 'Color de la línia divisòria de la barra de navegació';
$string['menubordercolordesc'] = 'Estableix el color de la línia divisòria de la barra de navegació.';

$string['menufontcolor'] = 'Color de text del menú principal';
$string['menufontcolordesc'] = 'Estableix el color del text del menú principal.';

$string['menuhovercolor'] = 'Color de fons sobre el menú principal';
$string['menuhovercolordesc'] = 'Estableix el color de fons del menú principal quan passar el cursor sobre els enllaços.';

$string['mobilemenubkcolor'] = 'Color de fons del menú para mòbil';
$string['mobilemenubkcolordesc'] = 'Estableix el color de fons del menú principal en mòbils (col·lapsat)';

$string['mobilemenufontcolor'] = 'Color del text del menú para mòbil';
$string['mobilemenufontcolordesc'] = 'Estableix el color de text del menú principal en mòbils (col·lapsat)';

$string['selectiontext'] = 'Color del text seleccionat';
$string['selectiontextdesc'] = 'Estableix el color del text seleccionat a la pantalla.';

$string['selectionbackground'] = 'Color de fons del text seleccionat';
$string['selectionbackgrounddesc'] = 'Estableix el color de fons del text seleccionat a la pantalla.';


// Course *********************************************************.
$string['coursesettings'] = 'Seccions del curs';
$string['coursesettingsheading'] = 'Configuració de les seccions del curs.';
$string['coursedesc'] = 'Configura les opcions de les seccions dels cursos com el títol, color de fons i bores.';

$string['coursesectionheaderbg'] = 'Color de fons de la capçalera';
$string['coursesectionheaderbgdesc'] = 'Estableix el color de fons de la capçalera de la secció del curs.';

$string['currentcolor'] = 'Color de realç de la secció actual';
$string['currentcolordesc'] = 'Estableix el color de realç de la secció actual.';

$string['coursesectionheaderborderstile'] = 'Estil de la bora inferior de la capçalera';
$string['coursesectionheaderborderstiledesc'] = 'Estableix l&#39;estil de la bora inferior de la capçalera de la secció del curs.';

$string['coursesectionheaderbordercolor'] = 'Color de la bora inferior de la capçalera';
$string['coursesectionheaderbordercolordesc'] = 'Estableix el color de la bora inferior de la capçalera de la secció del curs.';

$string['coursesectionheaderborderwidth'] = 'Gruix de la bora inferior de la capçalera';
$string['coursesectionheaderborderwidthdesc'] = 'Estableix el Gruix de la bora inferior de la capçalera de la secció del curs.';

$string['coursesectionheaderborderradiustop'] = 'Radi de les cantonades de la bora superior de la capçalera';
$string['coursesectionheaderborderradiustopdesc'] = 'Estableix el radi de les cantonades de la bora superior de la capçalera de la secció del curs.';

$string['coursesectionheaderborderradiusbottom'] = 'Radi de las cantonades de la bora inferior de la capçalera';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Estableix el radi de les cantonades de la bora inferior de la capçalera de la secció del curs.';

$string['coursesectionborderstile'] = 'Estil de la bora de la secció del curs';
$string['coursesectionborderstiledesc'] = 'Estableix l&#39;estil de la bora de la secció del curs.';

$string['coursesectionborderwidth'] = 'Gruix de la bora de la secció';
$string['coursesectionborderwidthdesc'] = 'Estableix el gruix de la bora de la secció del curs.';

$string['coursesectionbordercolor'] = 'Color de la bora de la secció';
$string['coursesectionbordercolordesc'] = 'Estableix el color de la bora de la secció del curs.';

$string['coursesectionborderradius'] = 'Radi de la bora de la secció';
$string['coursesectionborderradiusdesc'] = 'Estableix el Radi de la bora de les cantonades de la secció del curs.';

// Fonts ***********************************************************.
$string['fontsettings'] = 'Fonts';
$string['fontsettingsheading'] = 'Estableix les fonts utilitzades per la plantilla.';
$string['fontdesc'] = 'Selecciona la font de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> per al text, els encapçalaments i el títol. Selecciona també el joc de caracters a utilitzar (llatí està inclòs per defecte) i introdueix el valor correcte per al gruix de les fonts utilitzat o no es mostrarà.';

$string['fontname'] = 'Font principal';
$string['fontnamedesc'] = 'Estableix la font principal. Selecciona defecte o una font de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';

$string['fontsize'] = 'Mida de la font principal';
$string['fontsizedesc'] = 'Selecciona la mida per defecte de la font principal (en percentatge) utilitzada al lloc.';

$string['fontheadername'] = 'Font encapçalaments';
$string['fontheadernamedesc'] = 'Estableix la font dels encapçalaments utilitzats a la plantilla. Selecciona default o una font de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';

$string['fontcolor'] = 'Color de la font principal';
$string['fontcolordesc'] = 'Estableix el color de la font principal.';

$string['fontheadercolor'] = 'Color de la font dels encapçalaments';
$string['fontheadercolordesc'] = 'Estableix el color de la font dels encapçalaments utilitzats a la plantilla.';

$string['fontweight'] = 'Gruix de la font principal';
$string['fontweightdesc'] = 'Estableix el Gruix de la font principal. Introduir un valor entre 100 i 900 depenent de la font utilitzada.';

$string['fontheaderweight'] = 'Gruix de la font de encapçalaments';
$string['fontheaderweightdesc'] = 'Estableix el Gruix de la font dels encapçalaments. Introduir un valor entre 100 i 900 depenent de la font utilitzada.';

$string['fonttitlename'] = 'Font del títol del lloc';
$string['fonttitlenamedesc'] = 'Estableix la font del títol del lloc situat en la capçalera. Selecciona default o una font de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';

$string['fonttitlecolor'] = 'Color de la font del títol del lloc';
$string['fonttitlecolordesc'] = 'Estableix el color de la font del títol del lloc situat en la capçalera.';

$string['fonttitleweight'] = 'Gruix de la font del títol del lloc';
$string['fonttitleweightdesc'] = 'Estableix el Gruix de la font del títol del lloc. Introduir un valor entre 100 i 900 depenent de la font utilitzada.';

$string['fonttitlesize'] = 'Mida de la font del títol del lloc';
$string['fonttitlesizedesc'] = 'Mida de la font del títol del lloc situat a la capçalera. Introduir un valor decimal, per exemple: 24px';

$string['fonttitlecolorcourse'] = 'Color de la font del títol del curs';
$string['fonttitlecolorcoursedesc'] = 'Estableix el color de la font utilitzada al títol del curs.';

$string['fontsubset'] = 'Joc de caracters de Google Fonts';
$string['fontsubsetdesc'] = 'Seleccionar el joc de caracters de Google Fonts a utilitzat a més a més del llatí ja inclòs per defecte. S&#39;aplicarà a totes les fonts seleccionades.';

$string['menufontsize'] = 'Mida de la font de la barra de navegació';
$string['menufontsizedesc'] = 'Estableix la mida de la font utilitzada a la barra de navegació.';

$string['menufontpadding'] = 'Separació entre els ítems de la barra de navegació';
$string['menufontpaddingdesc'] = 'Estableix la separació entre els ítems de la barra de navegació.';

$string['fontblockheadercolor'] = 'Color de la font de la capçalera dels blocs';
$string['fontblockheadercolordesc'] = 'Estableix el color de la font de la capçalera dels blocs de moodle.';

$string['fontblockheaderweight'] = 'Gruix de la font de la capçalera dels blocs de moodle';
$string['fontblockheaderweightdesc'] = 'Estableix el gruix de la font de la capçalera dels blocs de moodle. Seleccionar un valor entre 100 i 900 depenent de la font seleccionada.';

$string['fontblockheadersize'] = 'Mida de la font de la capçalera dels blocs de moodle';
$string['fontblockheadersizedesc'] = 'Estableix la mida de la font utilitzada a la capçalera dels blocs de moodle. Seleccionar un valor de la llista.';

// Buttons *********************************************************.
$string['buttonsettings'] = 'Botons';
$string['buttonsettingsheading'] = 'Personalitzar els botons.';
$string['buttondesc'] = 'personalitza la forma i colors dels botons utilitzats a la plantilla.';

$string['buttonradius'] = 'Radi de les cantonades';
$string['buttonradiusdesc'] = '0 = cantonades quadrades. Un valor més alto és igual a cantonades més arrodonides .';

$string['buttoncolor'] = 'Colors dels botons';
$string['buttoncolordesc'] = 'El color dels botons principals.';

$string['buttonhovercolor'] = 'Color Hover dels botons';
$string['buttonhovercolordesc'] = 'Color del botó al passar el cursor por sobre.';

$string['buttontextcolor'] = 'Color del text dels botons';
$string['buttontextcolordesc'] = 'Color del text dels botons.';

$string['editfont'] = 'Color del text dels botons d&#39; <i>Edició</i> i <i>Personalitzar aquesta pàgina</i>';
$string['editfontdesc'] = 'Estableix el color del text dels botons d&#39; <i>Edició</i> i <i>Personalitzar aquesta pàgina</i>';

$string['editverticalpadding'] = 'Espaiat vertical dels botons d&#39;edició';
$string['edithorizontalpadding'] = 'Espaiat horitzontal dels botons d&#39;edició';
$string['edittopmargin'] = 'Marge superior dels botons d&#39;edició';


// Boton Login.
$string['logintextbutton'] = 'Entrar';

$string['buttonlogincolor'] = 'Color del botó Entrar';
$string['buttonlogincolordesc'] = 'Color del botó Entrar.';

$string['buttonloginhovercolor'] = 'Color Hover del botó Entrar';
$string['buttonloginhovercolordesc'] = 'Color del botó Entrar al passar el cursor per sobre.';

$string['buttonlogintextcolor'] = 'Color del text del botó Entrar';
$string['buttonlogintextcolordesc'] = 'Color del text del botó Entrar.';

$string['buttonloginpadding'] = 'Separació del text del botó Entrar';
$string['buttonloginpaddingdesc'] = 'Separació al voltant del text del botó Entrar. Número més alt = Botó més gran.';

$string['buttonloginheight'] = 'Alçada del botó Entrar';
$string['buttonloginheightdesc'] = 'Alçada del botó Entrar. Només si s&#39;utilitza el formulari d&#39;entrada a la capçalera.';

$string['buttonloginmargintop'] = 'Marge superior del botó Entrar';
$string['buttonloginmargintopdesc'] = 'Permet posicionar el botó Entrar si s&#39;han canviat els valors indicats anteriorment.';

$string['loginplaceholder'] = 'Usuari';
$string['passwordplaceholder'] = 'Contrasenya';


// Header ***********************************************************.
$string['headersettings'] = 'Capçalera';
$string['headersettingsheading'] = 'Personalització de la capçalera.';
$string['headerdesc'] = 'Mostrar alertes per avisar als usuaris, controlar la barra de navegació, mostrar el títol del lloc o el logotip, són algunes de les opcions de la capçalera.';


$string['enableheading'] = 'Mostrar nom del curs';
$string['enableheadingdesc'] = 'Estableix el mode de visualització del títol del curs a la capçalera.';

$string['sitetitlecoursesdisabled'] = 'Desactivat - mostra només el títol del curs a les pàgines del curs';
$string['sitetitlecoursesenabled'] = 'Activat - mostra el nom del lloc i el títol dels cursos a les pàgines del curs';

$string['sitetitlepaddingtop'] = 'Separació superior del nom del lloc';
$string['sitetitlepaddingtopdesc'] = 'Permet ajustar la separació, en píxels, de la part superior del nom del lloc.';

$string['sitetitlepaddingleft'] = 'Separació esquerra del nom del lloc';
$string['sitetitlepaddingleftdesc'] = 'Permet ajustar la separació, en píxels, de la part esquerra del nom del lloc.';

$string['sitetitlemaxwidth'] = 'Longitud màxima del nom del lloc';
$string['sitetitlemaxwidthdesc'] = 'Estableix la longitud màxima de caracters del nom del lloc. La longitud final dependrà de la font, mida i resolució de pantalla.';

$string['coursetitlepaddingtop'] = 'Separació superior del títol del curs';
$string['coursetitlepaddingtopdesc'] = 'Permet ajustar la separació, en píxels, de la part superior del títol del curs.';

$string['coursetitlepaddingleft'] = 'Separació esquerra del títol del curs';
$string['coursetitlepaddingleftdesc'] = 'Permet ajustar la separació, en píxels, de la part esquerra del títol del curs.';

$string['coursetitlemaxwidth'] = 'Amplada màxima del títol del curs';
$string['coursetitlemaxwidthdesc'] = 'Estableix l&#39;amplada màxima de l&#39;àrea on es mostra el títol del curs.';

$string['pageheaderheight'] = 'Alçada de la capçalera';
$string['pageheaderheightdesc'] = 'Estableix l&#39;alçada de la capçalera (incloent logotip i títols)';

$string['breadcrumbtitle'] = 'Nom del curs a la guia d&#39;exploració';
$string['breadcrumbtitledesc'] = 'Estableix el mode de visualització del títol del curso a la guia d&#39;exploració.';

$string['breadcrumbtitlefullname'] = 'Nom complert del curs';
$string['breadcrumbtitleshortname'] = 'Nom curt del curs / Codi';

$string['socialorsearch'] = 'Mostrar quadre de cerca o icones socials';
$string['socialorsearchdesc'] = 'Pots mostrar les icones socials o el quadre de cerca a la capçalera. <br />
    <strong>Pots configurar les icones socials a la secció "Xarxes socials"</strong>.';

$string['socialorsearchsocial'] = 'Mostrar icones de xarxes socials';
$string['socialorsearchsearch'] = 'Mostrar quadre de cerca';

$string['searchboxpaddingtop'] = 'Separació superior del quadre de cerca';
$string['searchboxpaddingtopdesc'] = 'Permet ajustar la separació, en píxels, del quadre de cerca (si es mostra).<br />
    <strong>Nota: La separació de les icones de xarxes socials pot configurar-se a la secció "Xarxes socials"</strong>.';

$string['usernav'] = 'Barra d&#39;usuari';

$string['menusettings'] = 'Menús de capçalera';
$string['menusettingsheading'] = 'Personalitza els menús de la capçalera superior.';

$string['logo'] = 'Logotip';
$string['logodesc'] = 'Puja l&#39;arxiu amb la imatge del logotip (170px x 80px max.). Formats admesos: .png, .jpg i .gif';

$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Carrega l&#39;arxiu favicon.ico que es mostra a la pestanya del navegador';

$string['enableavailablecourses'] = 'Mostrar el text "Cursos Disponibles"';
$string['enableavailablecoursesdesc'] = 'Mostrar el text <i>Cursos Disponibles</i> sobre el llistat de cursos a la pàgina inicial.';

$string['thiscourse'] = 'Aquest curs';

$string['loadtime'] = 'Pàgina carregada a ';

$string['loadingcolor'] = 'Color del carregador';
$string['loadingcolordesc'] = 'Color del carregador situat a la part superior de la pàgina.';

$string['sitetitle'] = 'Mostrar títol del lloc';
$string['sitetitledesc'] = 'Mostrar / Ocultar el títol del lloc.';

$string['sitetitletext'] = 'Nom del lloc';
$string['sitetitletextdesc'] = 'El nom del lloc que es mostrarà a la capçalera.';
$string['sitetitlecustom'] = 'Utilitzar nom del lloc personalitzat (Introduir el text al següent camp)';

$string['sitetitletext'] = 'Nom del lloc';
$string['sitetitletextdesc'] = 'Introduir el nom del lloc que es mostrarà a la capçalera (el nom del lloc configurat a l&#39;apartat "Pàgina Principal" no serà mostrat per Adaptable)';

$string['frontpagelogin'] = 'Formulari d&#39;entrada a la capçalera';
$string['frontpagelogindesc'] = 'Mostrar el formulari d&#39;entrada a la part superior de la capçalera. En cas contrari, es mostrarà només el botó.';

$string['displaylogin'] = 'Mostrar l&#39;entrada d&#39;usuari';
$string['displailogindesc'] = 'Selecciona el mètode d&#39;entrada de l&#39;usuari (quan estigui activat)';

$string['displayloginbutton'] = 'Botó';
$string['displayloginbox'] = 'Formulari';
$string['displayloginno'] = 'Sense entrada';

$string['enablemessagemenu'] = 'Mostrar Menú Missatges';
$string['enablemessagemenudesc'] = 'Mostra el menú missatges a la capçalera.';

$string['filteradminmessages'] = 'Filtrar missatges de l&#39;administrador Admin Messages';
$string['filteradminmessagesdesc'] = 'Activar per eliminar els missatges de l&#39;administrador. Això pot reduir els missatges del sistema rebuts pels alumnes i professors.';

$string['hideblocks'] = 'Ocultar blocs';
$string['showblocks'] = 'Mostrar blocs';
$string['fullscreen'] = 'Pantalla complerta';
$string['standardview'] = 'Vista estàndard';

$string['viewselect'] = 'Pantalla complerta com vista per defecte';
$string['viewselectdesc'] = 'Establir la vista per defecte a pantalla complerta (quan l&#39;opció zoom està activada)';

$string['enablezoom'] = 'Activar Zoom';
$string['enablezoomdesc'] = 'Permet als usuaris canviar entre pantalla complerta o ample fix de pantalla.';

$string['enableshowhideblocks'] = 'Activar Mostrar/Ocultar blocs';
$string['enableshowhideblocksdesc'] = 'Permet als usuaris mostrar / ocultar els blocs laterals.';

$string['fullscreenwidth'] = 'Amplada de pantalla completa';
$string['fullscreenwidthdesc'] = 'Estableix l&#39;amplada màxima de la pantalla a mode pantalla complerta / zoom.';


// Help Links ******************************************************.
$string['enablehelp'] = 'Enllaç d&#39;ajuda';
$string['enablehelpdesc'] = 'Afegeix un enllaç d&#39;ajuda a la barra de navegació.';

$string['helptitle'] = 'Ajuda per perfil';
$string['helptitle2'] = 'Enllaç d&#39;ajuda dependent del camp personalitzat al perfil.';

$string['helpprofilefield'] = 'Camp personalitzat per a l&#39;ajuda (opcional)';
$string['helpprofilefielddesc'] = 'Afegeix una regla d&#39;accés utilitzant un camp de perfil personalitzat. Exemple: usertipe=alumne';


// Courses Overlay *************************************************.
$string['rendereroverlaycolor'] = 'Color superposat';
$string['rendereroverlaycolordesc'] = 'El color superposat sobre el bloc de curs quan "blocs Superposats" està seleccionat.';

$string['rendereroverlaifontcolor'] = 'Color de text a la superposició';
$string['rendereroverlaifontcolordesc'] = 'El color de la font quan passa el cursor per sobre del bloc del curs i "blocs Superposats" està activat.';

$string['covbkcolor'] = 'Color de fons als blocs estil Coventry';
$string['covbkcolordesc'] = 'Estableix el color de superposició dels blocs quan s&#39;ha seleccionat l&#39;estil Coventry.';

$string['covfontcolor'] = 'Color del text als blocs estil Coventry';
$string['covfontcolordesc'] = 'Estableix el color del text als blocs estil Coventry.';

$string['covhidebutton'] = 'Mostrar el botó del curs als blocs estil Coventry';
$string['covhidebuttondesc'] = 'Mostrar / ocultar el botó del curs quan s&#39;utilitza l&#39;estil Coventry.';

$string['frontpagerendererdefaultimage'] = 'Imatge per defecte pels cursos';
$string['frontpagerendererdefaultimagedesc'] = 'Puja la imatge que s&#39;utilizarà per defecte als cursos que no disposin d&#39;ella. (només s&#39;aplica a l&#39;estil "blocs Superposats")';

$string['tilesshowcontacts'] = 'Mostrar els contactes del curs';
$string['tilesshowcontactsdesc'] = 'Mostra / Oculta els contactes del curs.';

$string['tilesbordercolor'] = 'Color de la bora dels blocs dels cursos';
$string['tilesbordercolordesc'] = 'Estableix el color de la bora dels blocs dels cursos.';

$string['tilescontactstitle'] = 'Mostrar el rol dels contactes del curs';
$string['tilescontactstitledesc'] = 'Mostra / Oculta el rol del contacte al curs. Si no es mostra, es mostrarà una imatge per a cada contacte.';

$string['tilesshowallcontacts'] = 'Mostrar tots els contactes del curs';
$string['tilesshowallcontactsdesc'] = 'Mostra tots els contactes del curs o només el principal.';

$string['course'] = 'Curs';


// Alerts **********************************************************
// Alert message if acting as other role.
$string['actingasrole'] = 'Estàs actuant actualment amb un paper diferent';

// Alert Hidden Course.
$string['alerthiddencourse'] = 'advertència suposat ocult';
$string['alerthiddencoursedesc'] = 'alerta en pantalla pàgina del curs si s\'oculta';

$string['alerthiddencoursetext-1'] = 'Aquest curs està oculta i no es pot accedir pels estudiants. ';
$string['alerthiddencoursetext-2'] = 'Feu clic aquí per actualitzar la configuració de';

// Alert Box Enable.
$string['enablealert'] = 'Activar Alerta {$a}';
$string['enablealertdesc'] = 'Activar l&#39;alerta {$a}.';

// Alert Box Generic Strings.
$string['alerttipe'] = 'Tipus d&#39;Alerta';
$string['alerttipedesc'] = 'Selecciona el tipus d&#39;alerta: informació (blau), avís (groc) o anunci (verd)';

$string['alerttext'] = 'text de l&#39;Alerta';
$string['alerttextdesc'] = 'Introdueix el text a mostrar a l&#39;alerta.';

$string['enablealerts'] = 'Activar / Desactivar Alertes';
$string['enablealertsdesc'] = 'Activar / desactivar alertes al lloc.';

$string['enablealertcoursepages'] = 'Activar Alertes a les pàginas dels cursos';
$string['enablealertcoursepagesdesc'] = 'Activar les alertes també a les pàgines dels cursos.';

$string['enablealertstriptags'] = 'Eliminar etiquetes HTML del text de l&#39;Alerta';
$string['enablealertstriptagsdesc'] = 'Si s&#39;activa, s&#39;eliminaran les etiquetes HTML del text. Si està desactivat, es permetrà introduir etiquetes HTML per exemple per afegir enllaços.';

$string['alertkeyvalue'] = 'Clau d&#39;identificació de l&#39;Alerta';
$string['alertkeyvalue_details'] = 'Aquesta clau identifica l&#39;alerta i permet el control de l&#39;eliminació de l&#39;alerta a la pantalla per part de l&#39;usuari. Si es canvia la clau, els usuaris tornaran a veure l&#39;alerta de nou.';

$string['alertsettingscourse'] = 'Configuració d\'alertes de cursos';

$string['alertsettingsgeneral'] = 'Configuració Alertes';
$string['alertsettings'] = 'Alerta {$a}';

$string['alertcount'] = 'Comptador d&#39;Alertes';
$string['alertcountdesc'] = 'Nombre d&#39;alertes a crear a continuació.';

$string['alertsettingsheading'] = 'Personalitzar les Alertes';
$string['alertdesc'] = 'Introdueix i personalitza el text de les alertes mostrades a la part superior de la pantalla. És possible crear més d&#39;una per mostrar-se a diferents tipus d&#39;usuaris. També existeix l&#39;opció de mostrar les alertes a la pàgina inicial i a les pàgines dels cursos.';

// Alerts Tipes.
$string['alertdisabled'] = 'Desactivat';
$string['alertdisabledesc'] = 'Desactivar aquesta alerta';

$string['alertinfo'] = 'Info';
$string['alertinfodesc'] = 'Mostra un missatge d&#39;informació.';

$string['alertwarning'] = 'Avís';
$string['alertwarningdesc'] = 'Mostra un missatge d&#39;avís.';

$string['alertannounce'] = 'Anunci';
$string['alertannouncedesc'] = 'Mostra un missatge d&#39;anunci.';

$string['alertprofilefield'] = 'Camp d&#39;usuari personalitzat Nom=Valor (opcional)';
$string['alertprofilefielddesc'] = 'Afegeix una regla d&#39;accés utilitzant un camp de perfil personalitzat. Exemple: usertipe=alumne';

// Alert Access - Visibility.
$string['alertaccessglobal'] = 'Visible per a tothom';
$string['alertaccessusers'] = 'Visible per a usuaris';
$string['alertaccessadmins'] = 'Visible per a administradors';
$string['alertaccessprofile'] = 'Afegir restricció per camp personalitzat';

$string['alertaccess'] = 'Visibilitat de l&#39;Alerta';
$string['alertaccessdesc'] = 'Estableix la visibilitat de l&#39;Alerta segons el seu tipus. Nota: Si s&#39;utilitza "Afegir restricció per camp personalitzat" necessitaràs afegir el camp personalitzat d&#39;usuari.';

// Moodle/Adaptable version alert messages.
$string['beta'] = 'VERSIÓ EN DESENVOLUPAMEN. NO UTILITZAR EN LLOCS EN PRODUCCIÓ';
$string['deprecated'] = 'VERSIÓ DE MOODLE OBSOLETA. NO UTILITZAR ADAPTABLE EN AQUEST LLOC';

// Alerts Colors****************************************************.
$string['alertcolorsheading'] = 'Personalitzar top Caixes d&#39;alerta';
$string['alertcolorsheadingdesc'] = 'establir colors i la icona.';

$string['alertcolorinfo'] = 'informació de color';
$string['alertcolorinfodesc'] = 'El color de la icona de les caixes d&#39;alerta Tipus d&#39;Informació';
$string['alertbackgroundcolorinfo'] = 'Informació de color de fons';
$string['alertbackgroundcolorinfodesc'] = 'color de fons de les caixes d&#39;alerta Tipus d&#39;Informació';
$string['alertbordercolorinfo'] = 'Informació Color de la vora';
$string['alertbordercolorinfodesc'] = 'Color de la vora de les caixes d&#39;alerta Tipus d&#39;Informació';
$string['alerticoninfo'] = 'informació d&#39;icones';
$string['alerticoninfodesc'] = 'Ajusteu el<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Font Awesome icona</a> per a ser utilitzats en esdeveniments en caixes d&#39;alerta de tipus Info. Introduïu el nom de la icona sense el fa- prefix.';

$string['alertcolorwarning'] = 'Notes de color';
$string['alertcolorwarningdesc'] = 'El color de la icona de les caixes d&#39;alerta tipus d&#39;advertència';
$string['alertbackgroundcolorwarning'] = 'Color de fons d&#39;advertència';
$string['alertbackgroundcolorwarningdesc'] = 'color de fons de les caixes d&#39;alerta tipus d&#39;advertència';
$string['alertbordercolorwarning'] = 'Notes Color de la vora';
$string['alertbordercolorwarningdesc'] = 'Color de la vora de les caixes d&#39;alerta tipus d&#39;advertència';
$string['alerticonwarning'] = 'Icona d&#39;alerta';
$string['alerticonwarningdesc'] = 'Ajusteu el<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Font Awesome icona</a> per a ser utilitzats en esdeveniments en caixes d&#39;alerta tipus d&#39;advertiment. Introduïu el nom de la icona sense el fa- prefix.';

$string['alertcolorsuccess'] = 'Anunci de color';
$string['alertcolorsuccessdesc'] = 'El color de la icona de les caixes d&#39;alerta tipus d&#39;anunci';
$string['alertbackgroundcolorsuccess'] = 'Anunci de color de fons';
$string['alertbackgroundcolorsuccessdesc'] = 'color de fons de les caixes d&#39;alerta tipus d&#39;anunci';
$string['alertbordercolorsuccess'] = 'Anunci Color de la vora';
$string['alertbordercolorsuccessdesc'] = 'Color de la vora de les caixes d&#39;alerta tipus d&#39;anunci';
$string['alerticonsuccess'] = 'Icona de l&#39;avís';
$string['alerticonsuccessdesc'] = 'Ajusteu el<a href="http://fortawesome.github.io/Font-Awesome/icons/">Fonts impressionant icona </a> que es usedin en caixes d&#39;alerta tipus d&#39;anunci. Introduïu el nom de la icona sense el fa- prefix.';

// Social Wall Settings ********************************************.
$string['socialwall'] = 'Format Social Wall';
$string['socialwallheading'] = 'Format Social Wall';
$string['socialwalldesc'] = 'Personalitza l&#39;estil del <a href="https://moodle.org/plugins/format_socialwall"> Format de curs SocialWall</a> (si s&#39;utilitza al lloc)';

$string['socialwallbackgroundcolor'] = 'Color de fons';
$string['socialwallbackgroundcolordesc'] = 'Estableix el color de fons.';

$string['socialwallsectionradius'] = 'Radi de la bora';
$string['socialwallsectionradiusdesc'] = 'Estableix la bora del Radi de les seccions.';

$string['socialwallbordertopstyle'] = 'Estil de la bora';
$string['socialwallbordertopstyledesc'] = 'Estableix l&#39;estil de la bora de les seccions.';

$string['socialwallborderwidth'] = 'Gruix de la bora';
$string['socialwallborderwidthdesc'] = 'Estableix el gruix de la bora de les seccions.';

$string['socialwallbordercolor'] = 'Color de la bora';
$string['socialwallbordercolordesc'] = 'Estableix el color de la bora de les seccions.';

$string['socialwallactionlinkcolor'] = 'Color dels enllaços d&#39;acció';
$string['socialwallactionlinkcolordesc'] = 'Estableix el color dels enllaços d&#39;acció.';

$string['socialwallactionlinkhovercolor'] = 'Color hover dels enllaços d&#39;acció';
$string['socialwallactionlinkhovercolordesc'] = 'Estableix el color hover dels enllaços d&#39;acció.';


// Mobile **********************************************************.
$string['mobilesettings'] = 'Configuració per a dispositius mòbils';
$string['mobilesettingsheading'] = 'Configura la plantilla per ser visualitzada en dispositius mòbils.';

$string['laioutmobilesettings'] = 'Configuració mòbil';
$string['laioutmobilesettingsdesc'] = 'Configuració específica per a dispositius mòbils.';

$string['hidealertsmobile'] = 'Ocultar Alertes';
$string['hidealertsmobiledesc'] = 'Oculta les alertes de la part superior de la pantalla (si estan activades)';

$string['hidesocialmobile'] = 'Ocultar les icones socials';
$string['hidesocialmobiledesc'] = 'Oculta les icones socials (si estan activades)';

$string['hidecoursetitlemobile'] = 'Oculta el títol del curs';
$string['hidecoursetitlemobiledesc'] = 'Oculta el títol del curs i del lloc';

$string['socialboxpaddingtopmobile'] = 'Separació superior del bloc d&#39;icones socials';
$string['socialboxpaddingbottommobile'] = 'Estableix la separació superior del bloc d&#39;icones socials';

$string['hidelogomobile'] = 'Ocultar logotip';
$string['hidelogomobiledesc'] = 'Ocultar el logotip.';

$string['hideheadermobile'] = 'Ocultar la capçalera';
$string['hideheadermobiledesc'] = 'Oculta la capçalera, logotip, icones socials i cerca.';

$string['hidebreadcrumbmobile'] = 'Ocultar ruta de navegació';
$string['hidebreadcrumbmobiledesc'] = 'Oculta la ruta de navegació.';

$string['hidepagefootermobile'] = 'Ocultar peu de pàgina';
$string['hidepagefootermobiledesc'] = 'Oculta el peu de pàgina.';

$string['hideslidermobile'] = 'Ocultar la presentació de diapositives';
$string['hideslidermobiledesc'] = 'Oculta la presentació de diapostives en la portada.';

// Layout **********************************************************.
$string['layoutsettings'] = 'Disposició';
$string['layoutdesc'] = 'Configuració de la disposició per defecte.';
$string['layoutsettingsheading'] = 'Controlar les diferents disposicions de la plantilla.';

$string['blockside'] = 'Posició dels blocs';
$string['blocksidedesc'] = 'Mostrar els blocs a la columna dreta o esquerra.';

$string['rightblocks'] = 'Columna dreta';
$string['leftblocks'] = 'Columna esquerra';

$string['blockicons'] = 'Mostrar icones als blocs';
$string['blockiconsdesc'] = 'Mostrar / Ocultar una icona relacionada amb el tipus de bloc al costat de la capçalera.';

$string['emoticonsize'] = 'Mida emoticones';
$string['emoticonsizedesc'] = 'Estableix la mida (amplada i alçada) de les emoticones.';

$string['helptarget'] = 'Nova finestra d&#39;ajuda';
$string['helptargetdesc'] = 'Obrir l&#39;ajuda a la mateixa finestra o a una nova.';

$string['hideinforum'] = 'Ocultar menús d&#39;ajuda i eines als fòrums';
$string['hideinforumdesc'] = 'Si s&#39;utilitza una amplada fixa de pantalla, és possible que els menús saltin a la línia inferior. Activant aquesta opció, s&#39;oculten els menús a les pàgines dels fòrums.';

$string['targetnewwindow'] = 'Nova finestra';
$string['targetsamewindow'] = 'Mateixa finestra';

$string['toolsmenu2'] = '2º Menú Eines';
$string['toolsmenu2desc'] = 'Pots configurar els ítems dels menús d&#39;eines. Cada línia consisteix en: títol de l&#39;ítem, enllaç (opcional), indicador de funció (opcional) i el codi d&#39;idioma o una llista de codis separada per comes (opcional, per mostrar l&#39;ítem depenent de l&#39;idioma de l&#39;usuari) separat per una línia vertical (|). També poden afegir-se sub-ítems utilitzant guions. Per exemple:
<pre>
Moodle communiti|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--Moodle Docs en español|http://docs.moodle.org/es|Documentación en español|es
Moodle.com|http://moodle.com/
</pre>';

$string['toolsmenulabel'] = 'Eines';
$string['toolsmenulabel2'] = 'Eines 2';
$string['events'] = 'Esdeveniments';
$string['misites'] = 'Els meus Cursos';
$string['hiddencourses'] = 'Cursos ocults';
$string['pastcourses'] = 'Cursos anteriors';
$string['people'] = 'Gent';
$string['help'] = 'Ajuda';

$string['dividingline'] = 'Línia divisòria de la capçalera';
$string['dividinglinedesc'] = 'Estableix el color de la línia divisòria de la capçalera.';

$string['dividingline2'] = 'Línia divisòria del peu de pàgina';
$string['dividingline2desc'] = 'Estableix el color de la línia divisòria del peu de pàgina.';

$string['navbarborder'] = 'Color de la bora de la part inferior de la barra de navegació';
$string['navbarborderdesc'] = 'Color de la bora de la part inferior de la barra de navegació.';

$string['navbarhover'] = 'Color hover del botó de la barra de navegació';
$string['navbarhoverdesc'] = 'Color dels botons de la barra de navegació al desplaçar el cursor per sobre.';

$string['showfooterblocks'] = 'Mostrar blocs al peu de pàgina';
$string['showfooterblocksdesc'] = 'Mostrar / Ocultar els blocs personalitzables del peu de pàgina.';

$string['breadcrumb'] = 'Color de fons de la ruta de navegació';
$string['breadcrumbdesc'] = 'Estableix el color de fons de la ruta de navegació.';

$string['breadcrumbtextcolor'] = 'Color del text de la ruta de navegació';
$string['breadcrumbtextcolordesc'] = 'Estableix el color del text de la ruta de navegació.';

$string['activebreadcrumb'] = 'Color de fons de la ruta de navegació activa';
$string['activebreadcrumbdesc'] = 'Estableix el color de fons de la ruta de navegació activa.';

$string['breadcrumbseparator'] = 'Separador de la ruta de navegació';
$string['breadcrumbseparatordesc'] = 'Estableix la icona de <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome</a>  utilitzant com a separador entre els ítems de la ruta de navegació. Introduir el nom de la icona SENSE el prefix fa-';

$string['breadcrumbhome'] = 'Inici de la ruta de navegació';
$string['breadcrumbhomedesc'] = 'Mostra l&#39;inici de la ruta de navegació com a icona o text.';

$string['breadcrumbhometext'] = 'text';
$string['breadcrumbhomeicon'] = 'Icona';

$string['menufontsize'] = 'Mida de font de la barra de navegació';
$string['menufontsizedesc'] = 'Estableix la mida de font de la barra de navegació.';

$string['enablemisitesdesc'] = 'Mostrar les activitats del curs';
$string['enablethiscoursedesc'] = 'Mostrar un desplegable amb les activitats del curs.';

$string['misitesexclude'] = 'Mostrar excloent els cursos ocults';
$string['misitesinclude'] = 'Mostrar incloent els cursos ocults';
$string['misitesdisabled'] = 'Desactivat';

$string['frnt-footer'] = 'Els blocs d&#39;aquesta àrea només seran visibles per als administradors.';

$string['enableticker'] = 'Mostrar els anuncis a la pàgina principal';
$string['enabletickerdesc'] = 'Mostra la barra d&#39;anuncis a la pàgina principal.';

$string['enabletickermi'] = 'Mostrar la barra d&#39;anuncis a La Meva Àrea Personal / Panell de control';
$string['enabletickermidesc'] = 'Mostra la barra d&#39;anuncis a La Meva Àrea Personal / Panell de control.';

$string['enabletickerc'] = 'Mostrar la barra d&#39;anuncis a les pàgines internes';
$string['enabletickercdesc'] = 'Mostra la barra d&#39;anuncis a les pàgines internes de moodle.';

$string['newstickercount'] = 'Número de barres d&#39;anuncis';
$string['newstickercountdesc'] = 'Defineix barres d&#39;anuncis amb diferents regles d&#39;accés per a mostrar-les a diferents tipus d&#39;usuaris.';

$string['tickertext'] = 'text de la barra d&#39;anuncis';
$string['tickertextdesc'] = 'Afegeix el text a mostrar a la barra d&#39;anuncis en format de llista. Veure l&#39;arxiu <a href="adaptable/README.md">README.md</a> per a més informació.';

$string['newmenu1trigger'] = 'Paraula clau per al Menú desplegable superior';
$string['newmenu1triggerdesc'] = 'Estableix una paraula clau per al Menú desplegable superior. Pots utilitzar les icones de Font Awesome.';

$string['menusheading'] = 'Configurar Navegació per als menús de la part superior de la capçalera';
$string['menustitledesc'] = 'Els menús d&#39;eines (a la barra de navegació) i els menús superiors (capçalera superior) poden ser restringits depenent d&#39;un camp personalitzat del perfil d&#39;usuari (opcional). Els menús segueixen el format dels menús estàndards de moodle:
<pre>
Moodle communiti|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>
';

$string['menusession'] = 'Emmagatzemar els detalls d&#39;accés a la sessió';
$string['menusessiondesc'] = 'S&#39;aconsella activar aquesta opció per optimitzar el rendiment en cas d&#39;utilizar diversos menús. Mantenir desactivada per proves.';

$string['disablecustommenu'] = 'Desactivar el menú personalitzat de Moodle';
$string['disablecustommenudesc'] = 'Desactiva el menú personalitzat de Moodle a la barra de navegació (seguirà funcionant a d&#39;altres plantilles instal·lades)';

$string['menusessionttl'] = 'Temps (minuts) d&#39;emmagatzematge de l&#39;accés als menús per sessió';
$string['menusessionttldesc'] = 'Nombre de minuts abans de reiniciar la sessió.';


// Tool menus ******************************************************.
$string['newmenudesc'] = 'Configurar els enllaços mostrats sota el menú de la capçalera superior.';
$string['newmenufield'] = 'Nom del camp personalitzat del perfil Field Name=Value (opcional)';
$string['newmenufielddesc'] = 'Afegeix una regla d&#39;accés utilitzant un camp de perfil personalitzat. Exemple: usertipe=alumne';
$string['newmenurequirelogin'] = 'Requereix Accedir';
$string['newmenurequirelogindesc'] = 'Si està activat aquest menú serà visible als usuaris que estiguin autentificats';

$string['menusdesc'] = '';

$string['newmenu2trigger'] = 'Paraula clau per al Menú desplegable superior';
$string['newmenu2triggerdesc'] = 'Estableix la paraula clau per al Menú desplegable superior.';

$string['enablemenus'] = 'Activar Menús';
$string['enablemenusdesc'] = 'Per motius de rendiment, es recomana no activar-ho si no s&#39;utilitzen els menús.';

$string['disablemenuscoursepages'] = 'Desactivar menús a les pàgines dels cursos';
$string['disablemenuscoursepagesdesc'] = 'Activant aquesta opció els menús només es mostraran a les pàgines del lloc, la pàgina inicial, l&#39;Àrea Personal, etc. i no es mostrarà a les pàgines dels cursos.';

$string['topmenufontsize'] = 'Mida font menú superior';
$string['topmenufontsizedesc'] = 'Estableix la mida de la font utilitzada al menú superior.';

$string['menuuseroverride'] = 'Permetre l&#39;anul·lació per l&#39;usuari';
$string['menuuseroverridedesc'] = 'Aquesta configuració controla l&#39;ús dels menús mitjançant el perfil d&#39;usuari. Per utilitzar aquesta funció, s&#39;ha de crear un camp personalitzat d&#39;usuari tipus llista amb els següents valors:
<pre>1. Sitewide (mostrarà el menú a tot el lloc)
2. Homepages Onli (mostrarà el menú només a la pàgina principal)
3. Hidden (no es mostraran els menús)</pre>
NO has d&#39;utilitzar la opció "Desactivar menús a les pàgines dels cursos" juntament als camps de perfil. Al seu lloc, selecciona "Homepage Onli".

Nota: Els usuaris hauran de sortir de moodle i tornar a entrar per aque els canvis facin efecte. Pot indicar-se una nota al crear el camp personalitzat.';

$string['menuoverrideprofilefield'] = 'Nom del camp personalitzat';
$string['menuoverrideprofilefielddesc'] = 'El nom del camp de perfil "list" utilitzat per l&#39;anul·lació per usuari.';
$string['menuoverrideprofilefielddefault'] = 'Ajust del menú superior';

$string['topmenuscount'] = 'Nombre de menús superiors';
$string['topmenuscountdesc'] = 'Estableix el nombre de menús superiors que vols afegir a la capçalera.';

$string['menusheadingvisibility'] = 'Configuració per a la visibilitat del menú superior';
$string['menusheadingvisibilitydesc'] = 'La següent configuració permet controlar on mostrar els menús i opcionalment permetre als usuaris la seva personalització.';

$string['newmenuheading'] = 'Menú superior';
$string['newmenu'] = 'Menú superior desplegable';
$string['newmenutitle'] = 'Títol menú superior';
$string['newmenutitledesc'] = 'El títol del menú apareixerà a la capçalera del lloc';
$string['newmenutitledefault'] = 'Menú';

$string['enabletoolsmenus'] = 'Activar menús d&#39;eines';
$string['enabletoolsmenusdesc'] = 'Per raons de rendiment, es recomana deixar-ho desactivat si no s&#39;utilitzen.';

$string['toolsmenuheading'] = 'Menús eines (a la barra de navegació)';
$string['toolsmenuheadingdesc'] = 'Pots configurar els enllaços a mostrar al menú d&#39;eines (a la barra de navegació).
 aquest format és similar a l&#39;utilitzat pels menús personalitzats de moodle però permet afegir les icones Font Awesome:
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';

$string['toolsmenuscount'] = 'Nombre de menús d&#39;eines';
$string['toolsmenuscountdesc'] = 'Estableix el nombre de menús d&#39;eines que vols a la barra de navegació.';

$string['toolsmenu'] = 'Menú d&#39;eines desplegable';
$string['toolsmenudesc'] = 'Afegeix un menú desplegable a la barra de navegació.';

$string['toolsmenutitle'] = 'títol menú d&#39;eines';
$string['toolsmenutitledefault'] = 'Eines';
$string['toolsmenutitledesc'] = 'Afegeix el títol a mostrar a la barra de navegació.';

$string['toolsmenulabel'] = 'Menú Eines';

$string['toolsmenufield'] = 'Nom del camp personalitzat del perfil Field Name=Value (opcional)';
$string['toolsmenufielddesc'] = 'Afegeix una regla d&#39;accés utilitzant un camp de perfil personalitzat. Exemple: usertipe=alumne';


// Social settings *************************************************.
$string['socialsettings'] = 'Xarxes socials';
$string['socialheading'] = 'Configuració de les icones de xarxes socials';
$string['socialtitledesc'] = '<pre>Pots desactivar la cerca i activar les icones de xarxes socials al seu lloc.
Per configurar les icones, introdueix una llista delimitada al campo "Llista d&#39;icones socials".
El format ha de ser:

url|títol|icona

Exemple:

http://localhost/moodle/course/search.php|Buscar en Moodle|fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https://instagram.com|Instagram|fa-instagram
http://example.com|Mi Web|fa-globe

El llistat d&#39;icones es troba a : <a href="http://fortawesome.github.io/Font-Awesome/icons">http://fortawesome.github.io/Font-Awesome/icons</a>Font-Awesome</pre>';

$string['socialsize'] = 'Configurar la mida de les icones socials';
$string['socialsizemobile'] = 'Configurar la mida de les icones socials a mòbils';
$string['socialpaddingtop'] = 'Ajustar la separació sota les icones socials (altera la posició vertical)';

$string['socialtarget'] = 'Format d&#39;apertura de la finestra d&#39;enllaços socials';
$string['socialtargetdesc'] = 'Obrir la xarxa social a la mateixa finestra o a una nova';

$string['socialsearchicon'] = 'Cercar a Moodle';
$string['socialsearchicondesc'] = 'Mostra el quadre de cerca al costat de les icones socials.';

$string['socialicondesc'] = 'Selecciona l&#39;icona de Font Awesome. Per exemple: fa-facebook';

$string['socialiconlist'] = 'Llista d&#39;icones socials';
$string['socialiconlistdesc'] = 'Introduir una llista delimitada per comes per configurar les icones de xarxes socials que necessites utilitzant el format: url|títol|icona';

// Analytics **********************************.
$string['analyticssettings'] = 'Analítics';
$string['analyticssettingsheading'] = 'Configura Google Analítics i/o Piwik';
$string['analyticssettingsdesc'] = 'Pots configurar Google Analítics i/o Piwik per al teu lloc moodle.';

// GA.
$string ['googleanalyticssettings'] = 'Google Analítics';
$string ['googleanalyticssettingsheading'] = 'Configura Google Analítics per al teu lloc';
$string ['googleanalyticssettingsdesc'] = 'Pots configurar múltiples codis per a Google Analítics i configurar-los per a diferents camps personalitzats d&#39;usuari.';

$string ['enableanalytics'] = 'Activar Google Analítics';
$string ['enableanalyticsdesc'] = 'Activar Google Analítics al lloc.';

$string ['analyticstext'] = 'Analítics Id';
$string ['analyticstextdesc'] = 'Introduir la ID de Google Analítics.';

$string['analyticscount'] = 'Nombre de camps de perfil';
$string['analyticscountdesc'] = 'Nombre de camps personalitzats a introduir a l&#39;àrea inferior.';

$string ['analyticsprofilefield'] = 'Nom del camp personalitzat del perfíl Field Name=Value (opcional)';
$string ['analyticsprofilefielddesc'] = 'Afegeix una regla d&#39;accés utilitzant un camp de perfil personalitzat. Exemple: usertipe=alumne';

// Piwik.
$string['piwiksettings'] = 'Piwik';
$string['piwiksettingsheading'] = 'Configurar Piwik';
$string['piwiksettingsdesc'] = 'Generar una URL neta per al rastreig avançat.';

$string['piwikenabled'] = 'Activar Piwik';
$string['piwikenableddesc'] = 'Activar el rastreig de Piwik per a Moodle.';

$string['piwiksiteid'] = 'ID del lloc';
$string['piwiksiteiddesc'] = 'Introduir la ID del lloc.';

$string['piwikimagetrack'] = 'Rastreig d&#39;imatge';
$string['piwikimagetrackdesc'] = 'Activar el rastreig per imatge per a navegadors amb JavaScript desactivat.';

$string['piwiksiteurl'] = 'URL de Piwik';
$string['piwiksiteurldesc'] = 'Introduir l&#39;adreça del lloc Piwik sense http (o https) ni la barra invertida.';

$string['piwiktrackadmin'] = 'Rastreig d&#39;administradors';
$string['piwiktrackadmindesc'] = 'Activar el rastreig d&#39;administradors (no recomanat)';


// Custom CSS ******************************.
$string['customcss'] = 'CSS i JS personalitzat';
$string['customcssdesc'] = 'Introdueix les regles CSS i codi JS personalitzats.';

$string['customcssjssettings'] = 'CSS i JS personalitzat';
$string['genericsettingsheading'] = 'Introdueix el teu propi codi CSS i Javascript';
$string['genericsettingsdescription'] = 'Introdueix el teu propi codi CSS i Javascript.';

$string['jssection'] = 'Javascript personalitzat';
$string['jssectiondesc'] = 'Introdueix el codi Javascript personalitzat.';

// Cache definitions.
$string['cachedef_userdata'] = 'El temps per desar una sessió d&#39;un usuari específic.';

// Section navigation ********************************.
$string['nextsection'] = 'Sigüent';
$string['previoussection'] = 'Anterior';

// General ******************************************.
$string['hide'] = 'Ocultar';
$string['show'] = 'Mostrar';

// Navbar Links menu *********************************.
$string['linksmenu'] = 'Menú enllaços';
